package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSubnetGroupRequest(
    subnetGroupName: String,
    description: Option[String] = None,
    subnetIds: Iterable[String],
    tags: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest = {
    import CreateSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest
      .builder()
      .subnetGroupName(subnetGroupName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupRequest
      .wrap(buildAwsValue())
}
object CreateSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupRequest =
      io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupRequest(
        subnetGroupNameValue,
        descriptionValue.map(value => value),
        subnetIdsValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def subnetGroupNameValue: String
    def descriptionValue: Option[String]
    def subnetIdsValue: List[String]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def subnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subnetGroupNameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def subnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIdsValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupRequest.ReadOnly {
    override def subnetGroupNameValue: String = impl.subnetGroupName(): String
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def subnetIdsValue: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest
  ): io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
