package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FailoverShardResponse(
    cluster: Option[io.github.vigoo.zioaws.memorydb.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.FailoverShardResponse = {
    import FailoverShardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.FailoverShardResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse
      .wrap(buildAwsValue())
}
object FailoverShardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.FailoverShardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse =
      io.github.vigoo.zioaws.memorydb.model
        .FailoverShardResponse(clusterValue.map(value => value.editable))
    def clusterValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly]
    def cluster: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
    ] = AwsError.unwrapOptionField("cluster", clusterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.FailoverShardResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.ReadOnly {
    override def clusterValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => io.github.vigoo.zioaws.memorydb.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.FailoverShardResponse
  ): io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.ReadOnly =
    new Wrapper(impl)
}
