package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeServiceUpdatesResponse(
    nextToken: Option[String] = None,
    serviceUpdates: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.ServiceUpdate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse = {
    import DescribeServiceUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        serviceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceUpdates)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesResponse
      .wrap(buildAwsValue())
}
object DescribeServiceUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesResponse(
        nextTokenValue.map(value => value),
        serviceUpdatesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[String]
    def serviceUpdatesValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly]
    ]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def serviceUpdates: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceUpdates", serviceUpdatesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def serviceUpdatesValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly]
    ] = scala
      .Option(impl.serviceUpdates())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesResponse.ReadOnly =
    new Wrapper(impl)
}
