package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSubnetGroupResponse(
    subnetGroup: Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse = {
    import DeleteSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse
      .builder()
      .optionallyWith(subnetGroup.map(value => value.buildAwsValue()))(
        _.subnetGroup
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse
      .wrap(buildAwsValue())
}
object DeleteSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse =
      io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse(
        subnetGroupValue.map(value => value.editable)
      )
    def subnetGroupValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly]
    def subnetGroup: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("subnetGroup", subnetGroupValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly {
    override def subnetGroupValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly] =
      scala
        .Option(impl.subnetGroup())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.SubnetGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse
  ): io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
