package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import java.lang.Integer
import io.github.vigoo.zioaws.memorydb.model.primitives.{
  IntegerOptional,
  TStamp
}
import scala.jdk.CollectionConverters.*
final case class DescribeEventsRequest(
    sourceName: Option[String] = None,
    sourceType: Option[io.github.vigoo.zioaws.memorydb.model.SourceType] = None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None,
    duration: Option[IntegerOptional] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest
      .builder()
      .optionallyWith(sourceName.map(value => value: java.lang.String))(
        _.sourceName
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeEventsRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeEventsRequest
      .wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DescribeEventsRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeEventsRequest(
        sourceNameValue.map(value => value),
        sourceTypeValue.map(value => value),
        startTimeValue.map(value => value),
        endTimeValue.map(value => value),
        durationValue.map(value => value),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def sourceNameValue: Option[String]
    def sourceTypeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SourceType]
    def startTimeValue: Option[TStamp]
    def endTimeValue: Option[TStamp]
    def durationValue: Option[IntegerOptional]
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def sourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceName", sourceNameValue)
    def sourceType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.memorydb.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def startTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTimeValue)
    def endTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTimeValue)
    def duration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("duration", durationValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeEventsRequest.ReadOnly {
    override def sourceNameValue: Option[String] =
      scala.Option(impl.sourceName()).map(value => value: String)
    override def sourceTypeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.SourceType.wrap(value)
      )
    override def startTimeValue: Option[TStamp] =
      scala.Option(impl.startTime()).map(value => value: TStamp)
    override def endTimeValue: Option[TStamp] =
      scala.Option(impl.endTime()).map(value => value: TStamp)
    override def durationValue: Option[IntegerOptional] =
      scala.Option(impl.duration()).map(value => value: IntegerOptional)
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeEventsRequest.ReadOnly =
    new Wrapper(impl)
}
