package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{AccessString, UserName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateUserRequest(
    userName: UserName,
    authenticationMode: Option[
      io.github.vigoo.zioaws.memorydb.model.AuthenticationMode
    ] = None,
    accessString: Option[AccessString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateUserRequest = {
    import UpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateUserRequest
      .builder()
      .userName(userName: java.lang.String)
      .optionallyWith(authenticationMode.map(value => value.buildAwsValue()))(
        _.authenticationMode
      )
      .optionallyWith(accessString.map(value => value: java.lang.String))(
        _.accessString
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UpdateUserRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UpdateUserRequest
      .wrap(buildAwsValue())
}
object UpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.UpdateUserRequest =
      io.github.vigoo.zioaws.memorydb.model.UpdateUserRequest(
        userNameValue,
        authenticationModeValue.map(value => value.editable),
        accessStringValue.map(value => value)
      )
    def userNameValue: UserName
    def authenticationModeValue: Option[
      io.github.vigoo.zioaws.memorydb.model.AuthenticationMode.ReadOnly
    ]
    def accessStringValue: Option[AccessString]
    def userName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userNameValue)
    def authenticationMode: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.AuthenticationMode.ReadOnly
    ] =
      AwsError.unwrapOptionField("authenticationMode", authenticationModeValue)
    def accessString: ZIO[Any, AwsError, AccessString] =
      AwsError.unwrapOptionField("accessString", accessStringValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateUserRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.UpdateUserRequest.ReadOnly {
    override def userNameValue: UserName = impl.userName(): UserName
    override def authenticationModeValue: Option[
      io.github.vigoo.zioaws.memorydb.model.AuthenticationMode.ReadOnly
    ] = scala
      .Option(impl.authenticationMode())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.AuthenticationMode.wrap(value)
      )
    override def accessStringValue: Option[AccessString] =
      scala.Option(impl.accessString()).map(value => value: AccessString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateUserRequest
  ): io.github.vigoo.zioaws.memorydb.model.UpdateUserRequest.ReadOnly =
    new Wrapper(impl)
}
