package io.github.vigoo.zioaws.memorydb.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceUpdateStatus {
  def unwrap: software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus
}
object ServiceUpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus
  ): io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus = value match {
    case software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.IN_PROGRESS =>
      val r = `in-progress`
      r
    case software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.COMPLETE =>
      val r = complete
      r
    case software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.SCHEDULED =>
      val r = scheduled
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object available
      extends io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.AVAILABLE
  }
  case object `in-progress`
      extends io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.IN_PROGRESS
  }
  case object complete
      extends io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.COMPLETE
  }
  case object scheduled
      extends io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus =
      software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus.SCHEDULED
  }
}
