package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsResponse(
    tagList: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ListTagsResponse = {
    import ListTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ListTagsResponse
      .builder()
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.wrap(buildAwsValue())
}
object ListTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ListTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ListTagsResponse =
      io.github.vigoo.zioaws.memorydb.model.ListTagsResponse(
        tagListValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def tagListValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def tagList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tagList", tagListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ListTagsResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.ReadOnly {
    override def tagListValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ListTagsResponse
  ): io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.ReadOnly =
    new Wrapper(impl)
}
