package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterResponse(
    cluster: Option[io.github.vigoo.zioaws.memorydb.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse
      .wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse =
      io.github.vigoo.zioaws.memorydb.model
        .CreateClusterResponse(clusterValue.map(value => value.editable))
    def clusterValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly]
    def cluster: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
    ] = AwsError.unwrapOptionField("cluster", clusterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.ReadOnly {
    override def clusterValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => io.github.vigoo.zioaws.memorydb.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterResponse
  ): io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.ReadOnly =
    new Wrapper(impl)
}
