package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEngineVersionsRequest(
    engineVersion: Option[String] = None,
    parameterGroupFamily: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None,
    defaultOnly: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest = {
    import DescribeEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest
      .builder()
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        parameterGroupFamily.map(value => value: java.lang.String)
      )(_.parameterGroupFamily)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(defaultOnly.map(value => value: java.lang.Boolean))(
        _.defaultOnly
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsRequest
      .wrap(buildAwsValue())
}
object DescribeEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsRequest(
        engineVersionValue.map(value => value),
        parameterGroupFamilyValue.map(value => value),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value),
        defaultOnlyValue.map(value => value)
      )
    def engineVersionValue: Option[String]
    def parameterGroupFamilyValue: Option[String]
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def defaultOnlyValue: Option[Boolean]
    def engineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def parameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("parameterGroupFamily", parameterGroupFamilyValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def defaultOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultOnly", defaultOnlyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsRequest.ReadOnly {
    override def engineVersionValue: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override def parameterGroupFamilyValue: Option[String] =
      scala.Option(impl.parameterGroupFamily()).map(value => value: String)
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def defaultOnlyValue: Option[Boolean] =
      scala.Option(impl.defaultOnly()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
