package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FailoverShardRequest(clusterName: String, shardName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.FailoverShardRequest = {
    import FailoverShardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.FailoverShardRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .shardName(shardName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.FailoverShardRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.FailoverShardRequest
      .wrap(buildAwsValue())
}
object FailoverShardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.FailoverShardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.FailoverShardRequest =
      io.github.vigoo.zioaws.memorydb.model
        .FailoverShardRequest(clusterNameValue, shardNameValue)
    def clusterNameValue: String
    def shardNameValue: String
    def clusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterNameValue)
    def shardName: ZIO[Any, Nothing, String] = ZIO.succeed(shardNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.FailoverShardRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.FailoverShardRequest.ReadOnly {
    override def clusterNameValue: String = impl.clusterName(): String
    override def shardNameValue: String = impl.shardName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.FailoverShardRequest
  ): io.github.vigoo.zioaws.memorydb.model.FailoverShardRequest.ReadOnly =
    new Wrapper(impl)
}
