package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSnapshotResponse(
    snapshot: Option[io.github.vigoo.zioaws.memorydb.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse = {
    import DeleteSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse
      .wrap(buildAwsValue())
}
object DeleteSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse =
      io.github.vigoo.zioaws.memorydb.model
        .DeleteSnapshotResponse(snapshotValue.map(value => value.editable))
    def snapshotValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly]
    def snapshot: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly
    ] = AwsError.unwrapOptionField("snapshot", snapshotValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.ReadOnly {
    override def snapshotValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.Snapshot.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse
  ): io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
