package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UntagResourceResponse(
    tagList: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UntagResourceResponse = {
    import UntagResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UntagResourceResponse
      .builder()
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse
      .wrap(buildAwsValue())
}
object UntagResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UntagResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse =
      io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse(
        tagListValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def tagListValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def tagList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tagList", tagListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UntagResourceResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.ReadOnly {
    override def tagListValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UntagResourceResponse
  ): io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.ReadOnly =
    new Wrapper(impl)
}
