package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Parameter(
    name: Option[String] = None,
    value: Option[String] = None,
    description: Option[String] = None,
    dataType: Option[String] = None,
    allowedValues: Option[String] = None,
    minimumEngineVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Parameter
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.Parameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Parameter =
      io.github.vigoo.zioaws.memorydb.model.Parameter(
        nameValue.map(value => value),
        valueValue.map(value => value),
        descriptionValue.map(value => value),
        dataTypeValue.map(value => value),
        allowedValuesValue.map(value => value),
        minimumEngineVersionValue.map(value => value)
      )
    def nameValue: Option[String]
    def valueValue: Option[String]
    def descriptionValue: Option[String]
    def dataTypeValue: Option[String]
    def allowedValuesValue: Option[String]
    def minimumEngineVersionValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def value: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", valueValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def dataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataTypeValue)
    def allowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValuesValue)
    def minimumEngineVersion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("minimumEngineVersion", minimumEngineVersionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Parameter
  ) extends io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def valueValue: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def dataTypeValue: Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override def allowedValuesValue: Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override def minimumEngineVersionValue: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Parameter
  ): io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly = new Wrapper(
    impl
  )
}
