package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSubnetGroupsRequest(
    subnetGroupName: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest = {
    import DescribeSubnetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest
      .builder()
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeSubnetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsRequest(
        subnetGroupNameValue.map(value => value),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def subnetGroupNameValue: Option[String]
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def subnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupNameValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsRequest.ReadOnly {
    override def subnetGroupNameValue: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
