package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotsRequest(
    clusterName: Option[String] = None,
    snapshotName: Option[String] = None,
    source: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    showDetail: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest = {
    import DescribeSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(showDetail.map(value => value: java.lang.Boolean))(
        _.showDetail
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsRequest
      .wrap(buildAwsValue())
}
object DescribeSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsRequest(
        clusterNameValue.map(value => value),
        snapshotNameValue.map(value => value),
        sourceValue.map(value => value),
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value),
        showDetailValue.map(value => value)
      )
    def clusterNameValue: Option[String]
    def snapshotNameValue: Option[String]
    def sourceValue: Option[String]
    def nextTokenValue: Option[String]
    def maxResultsValue: Option[IntegerOptional]
    def showDetailValue: Option[BooleanOptional]
    def clusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterNameValue)
    def snapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotNameValue)
    def source: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", sourceValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def showDetail: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showDetail", showDetailValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsRequest.ReadOnly {
    override def clusterNameValue: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override def snapshotNameValue: Option[String] =
      scala.Option(impl.snapshotName()).map(value => value: String)
    override def sourceValue: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def showDetailValue: Option[BooleanOptional] =
      scala.Option(impl.showDetail()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
