package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteClusterResponse(
    cluster: Option[io.github.vigoo.zioaws.memorydb.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse = {
    import DeleteClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse
      .wrap(buildAwsValue())
}
object DeleteClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse =
      io.github.vigoo.zioaws.memorydb.model
        .DeleteClusterResponse(clusterValue.map(value => value.editable))
    def clusterValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly]
    def cluster: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
    ] = AwsError.unwrapOptionField("cluster", clusterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.ReadOnly {
    override def clusterValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => io.github.vigoo.zioaws.memorydb.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse
  ): io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.ReadOnly =
    new Wrapper(impl)
}
