package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUserResponse(
    user: Option[io.github.vigoo.zioaws.memorydb.model.User] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateUserResponse = {
    import CreateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateUserResponse
      .wrap(buildAwsValue())
}
object CreateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.CreateUserResponse =
      io.github.vigoo.zioaws.memorydb.model
        .CreateUserResponse(userValue.map(value => value.editable))
    def userValue: Option[io.github.vigoo.zioaws.memorydb.model.User.ReadOnly]
    def user: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
    ] = AwsError.unwrapOptionField("user", userValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateUserResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.ReadOnly {
    override def userValue
        : Option[io.github.vigoo.zioaws.memorydb.model.User.ReadOnly] = scala
      .Option(impl.user())
      .map(value => io.github.vigoo.zioaws.memorydb.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateUserResponse
  ): io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.ReadOnly =
    new Wrapper(impl)
}
