package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.TStamp
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Node(
    name: Option[String] = None,
    status: Option[String] = None,
    availabilityZone: Option[String] = None,
    createTime: Option[TStamp] = None,
    endpoint: Option[io.github.vigoo.zioaws.memorydb.model.Endpoint] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Node = {
    import Node.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Node
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(createTime.map(value => value: Instant))(_.createTime)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Node.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Node.wrap(buildAwsValue())
}
object Node {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Node] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Node =
      io.github.vigoo.zioaws.memorydb.model.Node(
        nameValue.map(value => value),
        statusValue.map(value => value),
        availabilityZoneValue.map(value => value),
        createTimeValue.map(value => value),
        endpointValue.map(value => value.editable)
      )
    def nameValue: Option[String]
    def statusValue: Option[String]
    def availabilityZoneValue: Option[String]
    def createTimeValue: Option[TStamp]
    def endpointValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def availabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def createTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createTime", createTimeValue)
    def endpoint: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpointValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Node
  ) extends io.github.vigoo.zioaws.memorydb.model.Node.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def availabilityZoneValue: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override def createTimeValue: Option[TStamp] =
      scala.Option(impl.createTime()).map(value => value: TStamp)
    override def endpointValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly] =
      scala
        .Option(impl.endpoint())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.Endpoint.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Node
  ): io.github.vigoo.zioaws.memorydb.model.Node.ReadOnly = new Wrapper(impl)
}
