package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateParameterGroupRequest(
    parameterGroupName: String,
    family: String,
    description: Option[String] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest = {
    import CreateParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .family(family: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupRequest
      .wrap(buildAwsValue())
}
object CreateParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupRequest =
      io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupRequest(
        parameterGroupNameValue,
        familyValue,
        descriptionValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def parameterGroupNameValue: String
    def familyValue: String
    def descriptionValue: Option[String]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def parameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupNameValue)
    def family: ZIO[Any, Nothing, String] = ZIO.succeed(familyValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupRequest.ReadOnly {
    override def parameterGroupNameValue: String =
      impl.parameterGroupName(): String
    override def familyValue: String = impl.family(): String
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest
  ): io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
