package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{AccessString, UserName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUserRequest(
    userName: UserName,
    authenticationMode: io.github.vigoo.zioaws.memorydb.model.AuthenticationMode,
    accessString: AccessString,
    tags: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateUserRequest
      .builder()
      .userName(userName: java.lang.String)
      .authenticationMode(authenticationMode.buildAwsValue())
      .accessString(accessString: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateUserRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateUserRequest
      .wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.CreateUserRequest =
      io.github.vigoo.zioaws.memorydb.model.CreateUserRequest(
        userNameValue,
        authenticationModeValue.editable,
        accessStringValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def userNameValue: UserName
    def authenticationModeValue
        : io.github.vigoo.zioaws.memorydb.model.AuthenticationMode.ReadOnly
    def accessStringValue: AccessString
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def userName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userNameValue)
    def authenticationMode: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.memorydb.model.AuthenticationMode.ReadOnly
    ] = ZIO.succeed(authenticationModeValue)
    def accessString: ZIO[Any, Nothing, AccessString] =
      ZIO.succeed(accessStringValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateUserRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateUserRequest.ReadOnly {
    override def userNameValue: UserName = impl.userName(): UserName
    override def authenticationModeValue
        : io.github.vigoo.zioaws.memorydb.model.AuthenticationMode.ReadOnly =
      io.github.vigoo.zioaws.memorydb.model.AuthenticationMode
        .wrap(impl.authenticationMode())
    override def accessStringValue: AccessString =
      impl.accessString(): AccessString
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateUserRequest
  ): io.github.vigoo.zioaws.memorydb.model.CreateUserRequest.ReadOnly =
    new Wrapper(impl)
}
