package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Authentication(
    `type`: Option[io.github.vigoo.zioaws.memorydb.model.AuthenticationType] =
      None,
    passwordCount: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Authentication = {
    import Authentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Authentication
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(passwordCount.map(value => value: Integer))(
        _.passwordCount
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.Authentication.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Authentication.wrap(buildAwsValue())
}
object Authentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.Authentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Authentication =
      io.github.vigoo.zioaws.memorydb.model.Authentication(
        typeValue.map(value => value),
        passwordCountValue.map(value => value)
      )
    def typeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.AuthenticationType]
    def passwordCountValue: Option[IntegerOptional]
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.AuthenticationType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def passwordCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("passwordCount", passwordCountValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Authentication
  ) extends io.github.vigoo.zioaws.memorydb.model.Authentication.ReadOnly {
    override def typeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.AuthenticationType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.AuthenticationType.wrap(value)
        )
    override def passwordCountValue: Option[IntegerOptional] =
      scala.Option(impl.passwordCount()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Authentication
  ): io.github.vigoo.zioaws.memorydb.model.Authentication.ReadOnly =
    new Wrapper(impl)
}
