package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeUsersResponse(
    users: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.User]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse = {
    import DescribeUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeUsersResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeUsersResponse
      .wrap(buildAwsValue())
}
object DescribeUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DescribeUsersResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeUsersResponse(
        usersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def usersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.User.ReadOnly]]
    def nextTokenValue: Option[String]
    def users: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
    ]] = AwsError.unwrapOptionField("users", usersValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeUsersResponse.ReadOnly {
    override def usersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.User.ReadOnly]] =
      scala
        .Option(impl.users())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.User.wrap(item)
          }.toList
        )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeUsersResponse.ReadOnly =
    new Wrapper(impl)
}
