package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SlotMigration(progressPercentage: Option[Double] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.SlotMigration = {
    import SlotMigration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.SlotMigration
      .builder()
      .optionallyWith(progressPercentage.map(value => value: java.lang.Double))(
        _.progressPercentage
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.SlotMigration.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.SlotMigration.wrap(buildAwsValue())
}
object SlotMigration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.SlotMigration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.SlotMigration =
      io.github.vigoo.zioaws.memorydb.model
        .SlotMigration(progressPercentageValue.map(value => value))
    def progressPercentageValue: Option[Double]
    def progressPercentage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("progressPercentage", progressPercentageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.SlotMigration
  ) extends io.github.vigoo.zioaws.memorydb.model.SlotMigration.ReadOnly {
    override def progressPercentageValue: Option[Double] =
      scala.Option(impl.progressPercentage()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.SlotMigration
  ): io.github.vigoo.zioaws.memorydb.model.SlotMigration.ReadOnly = new Wrapper(
    impl
  )
}
