package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.ACLName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class User(
    name: Option[String] = None,
    status: Option[String] = None,
    accessString: Option[String] = None,
    aclNames: Option[Iterable[ACLName]] = None,
    minimumEngineVersion: Option[String] = None,
    authentication: Option[
      io.github.vigoo.zioaws.memorydb.model.Authentication
    ] = None,
    arn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.User
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(accessString.map(value => value: java.lang.String))(
        _.accessString
      )
      .optionallyWith(
        aclNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.aclNames)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(authentication.map(value => value.buildAwsValue()))(
        _.authentication
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.User.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.User =
      io.github.vigoo.zioaws.memorydb.model.User(
        nameValue.map(value => value),
        statusValue.map(value => value),
        accessStringValue.map(value => value),
        aclNamesValue.map(value => value),
        minimumEngineVersionValue.map(value => value),
        authenticationValue.map(value => value.editable),
        arnValue.map(value => value)
      )
    def nameValue: Option[String]
    def statusValue: Option[String]
    def accessStringValue: Option[String]
    def aclNamesValue: Option[List[ACLName]]
    def minimumEngineVersionValue: Option[String]
    def authenticationValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Authentication.ReadOnly]
    def arnValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def accessString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessString", accessStringValue)
    def aclNames: ZIO[Any, AwsError, List[ACLName]] =
      AwsError.unwrapOptionField("aclNames", aclNamesValue)
    def minimumEngineVersion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("minimumEngineVersion", minimumEngineVersionValue)
    def authentication: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Authentication.ReadOnly
    ] = AwsError.unwrapOptionField("authentication", authenticationValue)
    def arn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.User
  ) extends io.github.vigoo.zioaws.memorydb.model.User.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def accessStringValue: Option[String] =
      scala.Option(impl.accessString()).map(value => value: String)
    override def aclNamesValue: Option[List[ACLName]] = scala
      .Option(impl.aclNames())
      .map(value =>
        value.asScala.map { item =>
          item: ACLName
        }.toList
      )
    override def minimumEngineVersionValue: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override def authenticationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.Authentication.ReadOnly
    ] = scala
      .Option(impl.authentication())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.Authentication.wrap(value)
      )
    override def arnValue: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.User
  ): io.github.vigoo.zioaws.memorydb.model.User.ReadOnly = new Wrapper(impl)
}
