package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateSubnetGroupRequest(
    subnetGroupName: String,
    description: Option[String] = None,
    subnetIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest = {
    import UpdateSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest
      .builder()
      .subnetGroupName(subnetGroupName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupRequest
      .wrap(buildAwsValue())
}
object UpdateSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupRequest =
      io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupRequest(
        subnetGroupNameValue,
        descriptionValue.map(value => value),
        subnetIdsValue.map(value => value)
      )
    def subnetGroupNameValue: String
    def descriptionValue: Option[String]
    def subnetIdsValue: Option[List[String]]
    def subnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subnetGroupNameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def subnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIdsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupRequest.ReadOnly {
    override def subnetGroupNameValue: String = impl.subnetGroupName(): String
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def subnetIdsValue: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest
  ): io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
