package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{
  ACLName,
  IntegerOptional
}
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateClusterRequest(
    clusterName: String,
    description: Option[String] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    maintenanceWindow: Option[String] = None,
    snsTopicArn: Option[String] = None,
    snsTopicStatus: Option[String] = None,
    parameterGroupName: Option[String] = None,
    snapshotWindow: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    nodeType: Option[String] = None,
    engineVersion: Option[String] = None,
    replicaConfiguration: Option[
      io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest
    ] = None,
    shardConfiguration: Option[
      io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest
    ] = None,
    aclName: Option[ACLName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest = {
    import UpdateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(snsTopicStatus.map(value => value: java.lang.String))(
        _.snsTopicStatus
      )
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(replicaConfiguration.map(value => value.buildAwsValue()))(
        _.replicaConfiguration
      )
      .optionallyWith(shardConfiguration.map(value => value.buildAwsValue()))(
        _.shardConfiguration
      )
      .optionallyWith(aclName.map(value => value: java.lang.String))(_.aclName)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UpdateClusterRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UpdateClusterRequest
      .wrap(buildAwsValue())
}
object UpdateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.UpdateClusterRequest =
      io.github.vigoo.zioaws.memorydb.model.UpdateClusterRequest(
        clusterNameValue,
        descriptionValue.map(value => value),
        securityGroupIdsValue.map(value => value),
        maintenanceWindowValue.map(value => value),
        snsTopicArnValue.map(value => value),
        snsTopicStatusValue.map(value => value),
        parameterGroupNameValue.map(value => value),
        snapshotWindowValue.map(value => value),
        snapshotRetentionLimitValue.map(value => value),
        nodeTypeValue.map(value => value),
        engineVersionValue.map(value => value),
        replicaConfigurationValue.map(value => value.editable),
        shardConfigurationValue.map(value => value.editable),
        aclNameValue.map(value => value)
      )
    def clusterNameValue: String
    def descriptionValue: Option[String]
    def securityGroupIdsValue: Option[List[String]]
    def maintenanceWindowValue: Option[String]
    def snsTopicArnValue: Option[String]
    def snsTopicStatusValue: Option[String]
    def parameterGroupNameValue: Option[String]
    def snapshotWindowValue: Option[String]
    def snapshotRetentionLimitValue: Option[IntegerOptional]
    def nodeTypeValue: Option[String]
    def engineVersionValue: Option[String]
    def replicaConfigurationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest.ReadOnly
    ]
    def shardConfigurationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest.ReadOnly
    ]
    def aclNameValue: Option[ACLName]
    def clusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterNameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def securityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIdsValue)
    def maintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindowValue)
    def snsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
    def snsTopicStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicStatus", snsTopicStatusValue)
    def parameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupNameValue)
    def snapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindowValue)
    def snapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] = AwsError
      .unwrapOptionField("snapshotRetentionLimit", snapshotRetentionLimitValue)
    def nodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeTypeValue)
    def engineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def replicaConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaConfiguration",
      replicaConfigurationValue
    )
    def shardConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("shardConfiguration", shardConfigurationValue)
    def aclName: ZIO[Any, AwsError, ACLName] =
      AwsError.unwrapOptionField("aclName", aclNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.UpdateClusterRequest.ReadOnly {
    override def clusterNameValue: String = impl.clusterName(): String
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def securityGroupIdsValue: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def maintenanceWindowValue: Option[String] =
      scala.Option(impl.maintenanceWindow()).map(value => value: String)
    override def snsTopicArnValue: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override def snsTopicStatusValue: Option[String] =
      scala.Option(impl.snsTopicStatus()).map(value => value: String)
    override def parameterGroupNameValue: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override def snapshotWindowValue: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override def snapshotRetentionLimitValue: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => value: IntegerOptional)
    override def nodeTypeValue: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override def engineVersionValue: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override def replicaConfigurationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest.ReadOnly
    ] = scala
      .Option(impl.replicaConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest
          .wrap(value)
      )
    override def shardConfigurationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest.ReadOnly
    ] = scala
      .Option(impl.shardConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest
          .wrap(value)
      )
    override def aclNameValue: Option[ACLName] =
      scala.Option(impl.aclName()).map(value => value: ACLName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest
  ): io.github.vigoo.zioaws.memorydb.model.UpdateClusterRequest.ReadOnly =
    new Wrapper(impl)
}
