package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UnprocessedCluster(
    clusterName: Option[String] = None,
    errorType: Option[String] = None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UnprocessedCluster = {
    import UnprocessedCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(errorType.map(value => value: java.lang.String))(
        _.errorType
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster
      .wrap(buildAwsValue())
}
object UnprocessedCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster =
      io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster(
        clusterNameValue.map(value => value),
        errorTypeValue.map(value => value),
        errorMessageValue.map(value => value)
      )
    def clusterNameValue: Option[String]
    def errorTypeValue: Option[String]
    def errorMessageValue: Option[String]
    def clusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterNameValue)
    def errorType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorType", errorTypeValue)
    def errorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ) extends io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster.ReadOnly {
    override def clusterNameValue: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override def errorTypeValue: Option[String] =
      scala.Option(impl.errorType()).map(value => value: String)
    override def errorMessageValue: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ): io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster.ReadOnly =
    new Wrapper(impl)
}
