package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SubnetGroup(
    name: Option[String] = None,
    description: Option[String] = None,
    vpcId: Option[String] = None,
    subnets: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Subnet]] =
      None,
    arn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.SubnetGroup = {
    import SubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.SubnetGroup
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.SubnetGroup.wrap(buildAwsValue())
}
object SubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.SubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.SubnetGroup =
      io.github.vigoo.zioaws.memorydb.model.SubnetGroup(
        nameValue.map(value => value),
        descriptionValue.map(value => value),
        vpcIdValue.map(value => value),
        subnetsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        arnValue.map(value => value)
      )
    def nameValue: Option[String]
    def descriptionValue: Option[String]
    def vpcIdValue: Option[String]
    def subnetsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Subnet.ReadOnly]]
    def arnValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def vpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcIdValue)
    def subnets: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Subnet.ReadOnly
    ]] = AwsError.unwrapOptionField("subnets", subnetsValue)
    def arn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.SubnetGroup
  ) extends io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def vpcIdValue: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override def subnetsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Subnet.ReadOnly]] =
      scala
        .Option(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Subnet.wrap(item)
          }.toList
        )
    override def arnValue: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.SubnetGroup
  ): io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly = new Wrapper(
    impl
  )
}
