package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Subnet(
    identifier: Option[String] = None,
    availabilityZone: Option[
      io.github.vigoo.zioaws.memorydb.model.AvailabilityZone
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Subnet
      .builder()
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .optionallyWith(availabilityZone.map(value => value.buildAwsValue()))(
        _.availabilityZone
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Subnet.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Subnet =
      io.github.vigoo.zioaws.memorydb.model.Subnet(
        identifierValue.map(value => value),
        availabilityZoneValue.map(value => value.editable)
      )
    def identifierValue: Option[String]
    def availabilityZoneValue: Option[
      io.github.vigoo.zioaws.memorydb.model.AvailabilityZone.ReadOnly
    ]
    def identifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifierValue)
    def availabilityZone: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.AvailabilityZone.ReadOnly
    ] = AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Subnet
  ) extends io.github.vigoo.zioaws.memorydb.model.Subnet.ReadOnly {
    override def identifierValue: Option[String] =
      scala.Option(impl.identifier()).map(value => value: String)
    override def availabilityZoneValue: Option[
      io.github.vigoo.zioaws.memorydb.model.AvailabilityZone.ReadOnly
    ] = scala
      .Option(impl.availabilityZone())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.AvailabilityZone.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Subnet
  ): io.github.vigoo.zioaws.memorydb.model.Subnet.ReadOnly = new Wrapper(impl)
}
