package io.github.vigoo.zioaws.memorydb.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ShardConfigurationRequest(
    shardCount: Option[
      io.github.vigoo.zioaws.memorydb.model.primitives.Integer
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest = {
    import ShardConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
      .builder()
      .optionallyWith(shardCount.map(value => value: Integer))(_.shardCount)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest
      .wrap(buildAwsValue())
}
object ShardConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest =
      io.github.vigoo.zioaws.memorydb.model
        .ShardConfigurationRequest(shardCountValue.map(value => value))
    def shardCountValue
        : Option[io.github.vigoo.zioaws.memorydb.model.primitives.Integer]
    def shardCount: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.primitives.Integer
    ] = AwsError.unwrapOptionField("shardCount", shardCountValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest.ReadOnly {
    override def shardCountValue
        : Option[io.github.vigoo.zioaws.memorydb.model.primitives.Integer] =
      scala
        .Option(impl.shardCount())
        .map(value =>
          value: io.github.vigoo.zioaws.memorydb.model.primitives.Integer
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ): io.github.vigoo.zioaws.memorydb.model.ShardConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
