package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ShardConfiguration(
    slots: Option[String] = None,
    replicaCount: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardConfiguration = {
    import ShardConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardConfiguration
      .builder()
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(replicaCount.map(value => value: Integer))(_.replicaCount)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ShardConfiguration.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ShardConfiguration
      .wrap(buildAwsValue())
}
object ShardConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ShardConfiguration =
      io.github.vigoo.zioaws.memorydb.model.ShardConfiguration(
        slotsValue.map(value => value),
        replicaCountValue.map(value => value)
      )
    def slotsValue: Option[String]
    def replicaCountValue: Option[IntegerOptional]
    def slots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slotsValue)
    def replicaCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("replicaCount", replicaCountValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ) extends io.github.vigoo.zioaws.memorydb.model.ShardConfiguration.ReadOnly {
    override def slotsValue: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
    override def replicaCountValue: Option[IntegerOptional] =
      scala.Option(impl.replicaCount()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfiguration
  ): io.github.vigoo.zioaws.memorydb.model.ShardConfiguration.ReadOnly =
    new Wrapper(impl)
}
