package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.TStamp
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ServiceUpdate(
    clusterName: Option[String] = None,
    serviceUpdateName: Option[String] = None,
    releaseDate: Option[TStamp] = None,
    description: Option[String] = None,
    status: Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus] =
      None,
    `type`: Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateType] =
      None,
    nodesUpdated: Option[String] = None,
    autoUpdateStartDate: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ServiceUpdate = {
    import ServiceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ServiceUpdate
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(releaseDate.map(value => value: Instant))(_.releaseDate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(nodesUpdated.map(value => value: java.lang.String))(
        _.nodesUpdated
      )
      .optionallyWith(autoUpdateStartDate.map(value => value: Instant))(
        _.autoUpdateStartDate
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.wrap(buildAwsValue())
}
object ServiceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ServiceUpdate =
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdate(
        clusterNameValue.map(value => value),
        serviceUpdateNameValue.map(value => value),
        releaseDateValue.map(value => value),
        descriptionValue.map(value => value),
        statusValue.map(value => value),
        typeValue.map(value => value),
        nodesUpdatedValue.map(value => value),
        autoUpdateStartDateValue.map(value => value)
      )
    def clusterNameValue: Option[String]
    def serviceUpdateNameValue: Option[String]
    def releaseDateValue: Option[TStamp]
    def descriptionValue: Option[String]
    def statusValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus]
    def typeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateType]
    def nodesUpdatedValue: Option[String]
    def autoUpdateStartDateValue: Option[TStamp]
    def clusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterNameValue)
    def serviceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateNameValue)
    def releaseDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("releaseDate", releaseDateValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdateType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def nodesUpdated: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodesUpdated", nodesUpdatedValue)
    def autoUpdateStartDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("autoUpdateStartDate", autoUpdateStartDateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ) extends io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly {
    override def clusterNameValue: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override def serviceUpdateNameValue: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override def releaseDateValue: Option[TStamp] =
      scala.Option(impl.releaseDate()).map(value => value: TStamp)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def statusValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus.wrap(value)
        )
    override def typeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.ServiceUpdateType.wrap(value)
        )
    override def nodesUpdatedValue: Option[String] =
      scala.Option(impl.nodesUpdated()).map(value => value: String)
    override def autoUpdateStartDateValue: Option[TStamp] =
      scala.Option(impl.autoUpdateStartDate()).map(value => value: TStamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdate
  ): io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly = new Wrapper(
    impl
  )
}
