package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReshardingStatus(
    slotMigration: Option[io.github.vigoo.zioaws.memorydb.model.SlotMigration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ReshardingStatus = {
    import ReshardingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ReshardingStatus
      .builder()
      .optionallyWith(slotMigration.map(value => value.buildAwsValue()))(
        _.slotMigration
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ReshardingStatus.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ReshardingStatus.wrap(buildAwsValue())
}
object ReshardingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ReshardingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ReshardingStatus =
      io.github.vigoo.zioaws.memorydb.model
        .ReshardingStatus(slotMigrationValue.map(value => value.editable))
    def slotMigrationValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SlotMigration.ReadOnly]
    def slotMigration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.SlotMigration.ReadOnly
    ] = AwsError.unwrapOptionField("slotMigration", slotMigrationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ReshardingStatus
  ) extends io.github.vigoo.zioaws.memorydb.model.ReshardingStatus.ReadOnly {
    override def slotMigrationValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SlotMigration.ReadOnly] =
      scala
        .Option(impl.slotMigration())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.SlotMigration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ReshardingStatus
  ): io.github.vigoo.zioaws.memorydb.model.ReshardingStatus.ReadOnly =
    new Wrapper(impl)
}
