package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetParameterGroupRequest(
    parameterGroupName: String,
    allParameters: Option[Boolean] = None,
    parameterNames: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest = {
    import ResetParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(allParameters.map(value => value: java.lang.Boolean))(
        _.allParameters
      )
      .optionallyWith(
        parameterNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.parameterNames)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupRequest
      .wrap(buildAwsValue())
}
object ResetParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupRequest =
      io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupRequest(
        parameterGroupNameValue,
        allParametersValue.map(value => value),
        parameterNamesValue.map(value => value)
      )
    def parameterGroupNameValue: String
    def allParametersValue: Option[Boolean]
    def parameterNamesValue: Option[List[String]]
    def parameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupNameValue)
    def allParameters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allParameters", allParametersValue)
    def parameterNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("parameterNames", parameterNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupRequest.ReadOnly {
    override def parameterGroupNameValue: String =
      impl.parameterGroupName(): String
    override def allParametersValue: Option[Boolean] =
      scala.Option(impl.allParameters()).map(value => value: Boolean)
    override def parameterNamesValue: Option[List[String]] = scala
      .Option(impl.parameterNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest
  ): io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
