package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParameterGroup(
    name: Option[String] = None,
    family: Option[String] = None,
    description: Option[String] = None,
    arn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ParameterGroup = {
    import ParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ParameterGroup
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ParameterGroup.wrap(buildAwsValue())
}
object ParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ParameterGroup =
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup(
        nameValue.map(value => value),
        familyValue.map(value => value),
        descriptionValue.map(value => value),
        arnValue.map(value => value)
      )
    def nameValue: Option[String]
    def familyValue: Option[String]
    def descriptionValue: Option[String]
    def arnValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def family: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("family", familyValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def arn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ) extends io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def familyValue: Option[String] =
      scala.Option(impl.family()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def arnValue: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterGroup
  ): io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly =
    new Wrapper(impl)
}
