package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{
  FilterValue,
  FilterName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Filter(name: FilterName, values: Iterable[FilterValue]) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Filter
      .builder()
      .name(name: java.lang.String)
      .values(values.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Filter.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Filter =
      io.github.vigoo.zioaws.memorydb.model.Filter(nameValue, valuesValue)
    def nameValue: FilterName
    def valuesValue: List[FilterValue]
    def name: ZIO[Any, Nothing, FilterName] = ZIO.succeed(nameValue)
    def values: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(valuesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Filter
  ) extends io.github.vigoo.zioaws.memorydb.model.Filter.ReadOnly {
    override def nameValue: FilterName = impl.name(): FilterName
    override def valuesValue: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        item: FilterValue
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Filter
  ): io.github.vigoo.zioaws.memorydb.model.Filter.ReadOnly = new Wrapper(impl)
}
