package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.TStamp
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Event(
    sourceName: Option[String] = None,
    sourceType: Option[io.github.vigoo.zioaws.memorydb.model.SourceType] = None,
    message: Option[String] = None,
    date: Option[TStamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Event
      .builder()
      .optionallyWith(sourceName.map(value => value: java.lang.String))(
        _.sourceName
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(date.map(value => value: Instant))(_.date)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Event =
      io.github.vigoo.zioaws.memorydb.model.Event(
        sourceNameValue.map(value => value),
        sourceTypeValue.map(value => value),
        messageValue.map(value => value),
        dateValue.map(value => value)
      )
    def sourceNameValue: Option[String]
    def sourceTypeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SourceType]
    def messageValue: Option[String]
    def dateValue: Option[TStamp]
    def sourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceName", sourceNameValue)
    def sourceType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.memorydb.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def message: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", messageValue)
    def date: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", dateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Event
  ) extends io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly {
    override def sourceNameValue: Option[String] =
      scala.Option(impl.sourceName()).map(value => value: String)
    override def sourceTypeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.SourceType.wrap(value)
      )
    override def messageValue: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override def dateValue: Option[TStamp] =
      scala.Option(impl.date()).map(value => value: TStamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Event
  ): io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly = new Wrapper(impl)
}
