package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EngineVersionInfo(
    engineVersion: Option[String] = None,
    enginePatchVersion: Option[String] = None,
    parameterGroupFamily: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.EngineVersionInfo = {
    import EngineVersionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
      .builder()
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(enginePatchVersion.map(value => value: java.lang.String))(
        _.enginePatchVersion
      )
      .optionallyWith(
        parameterGroupFamily.map(value => value: java.lang.String)
      )(_.parameterGroupFamily)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo
      .wrap(buildAwsValue())
}
object EngineVersionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo =
      io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo(
        engineVersionValue.map(value => value),
        enginePatchVersionValue.map(value => value),
        parameterGroupFamilyValue.map(value => value)
      )
    def engineVersionValue: Option[String]
    def enginePatchVersionValue: Option[String]
    def parameterGroupFamilyValue: Option[String]
    def engineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def enginePatchVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("enginePatchVersion", enginePatchVersionValue)
    def parameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("parameterGroupFamily", parameterGroupFamilyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ) extends io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly {
    override def engineVersionValue: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override def enginePatchVersionValue: Option[String] =
      scala.Option(impl.enginePatchVersion()).map(value => value: String)
    override def parameterGroupFamilyValue: Option[String] =
      scala.Option(impl.parameterGroupFamily()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ): io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly =
    new Wrapper(impl)
}
