package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotsResponse(
    nextToken: Option[String] = None,
    snapshots: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.Snapshot]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse = {
    import DescribeSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsResponse
      .wrap(buildAwsValue())
}
object DescribeSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsResponse(
        nextTokenValue.map(value => value),
        snapshotsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[String]
    def snapshotsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly]]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def snapshots: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("snapshots", snapshotsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsResponse.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def snapshotsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly]
    ] = scala
      .Option(impl.snapshots())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.Snapshot.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
