package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeServiceUpdatesRequest(
    serviceUpdateName: Option[String] = None,
    clusterNames: Option[Iterable[String]] = None,
    status: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus]
    ] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest = {
    import DescribeServiceUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        clusterNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterNames)
      .optionallyWith(
        status.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusWithStrings)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesRequest
      .wrap(buildAwsValue())
}
object DescribeServiceUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesRequest(
        serviceUpdateNameValue.map(value => value),
        clusterNamesValue.map(value => value),
        statusValue.map(value => value),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def serviceUpdateNameValue: Option[String]
    def clusterNamesValue: Option[List[String]]
    def statusValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus]
    ]
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def serviceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateNameValue)
    def clusterNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterNames", clusterNamesValue)
    def status: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus
    ]] = AwsError.unwrapOptionField("status", statusValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly {
    override def serviceUpdateNameValue: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override def clusterNamesValue: Option[List[String]] = scala
      .Option(impl.clusterNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def statusValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus]
    ] = scala
      .Option(impl.status())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus.wrap(item)
        }.toList
      )
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeServiceUpdatesRequest.ReadOnly =
    new Wrapper(impl)
}
