package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParametersResponse(
    nextToken: Option[String] = None,
    parameters: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.Parameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse = {
    import DescribeParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeParametersResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeParametersResponse
      .wrap(buildAwsValue())
}
object DescribeParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeParametersResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeParametersResponse(
        nextTokenValue.map(value => value),
        parametersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[String]
    def parametersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly]]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def parameters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parametersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeParametersResponse.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def parametersValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly]
    ] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeParametersResponse.ReadOnly =
    new Wrapper(impl)
}
