package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParameterGroupsRequest(
    parameterGroupName: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest = {
    import DescribeParameterGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeParameterGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsRequest(
        parameterGroupNameValue.map(value => value),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def parameterGroupNameValue: Option[String]
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def parameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupNameValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly {
    override def parameterGroupNameValue: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
