package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEngineVersionsResponse(
    nextToken: Option[String] = None,
    engineVersions: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse = {
    import DescribeEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        engineVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineVersions)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsResponse
      .wrap(buildAwsValue())
}
object DescribeEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsResponse(
        nextTokenValue.map(value => value),
        engineVersionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[String]
    def engineVersionsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly]
    ]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def engineVersions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("engineVersions", engineVersionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def engineVersionsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly]
    ] = scala
      .Option(impl.engineVersions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
