package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClustersResponse(
    nextToken: Option[String] = None,
    clusters: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Cluster]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse = {
    import DescribeClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeClustersResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeClustersResponse
      .wrap(buildAwsValue())
}
object DescribeClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeClustersResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeClustersResponse(
        nextTokenValue.map(value => value),
        clustersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[String]
    def clustersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly]]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def clusters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
    ]] = AwsError.unwrapOptionField("clusters", clustersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeClustersResponse.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def clustersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly]] =
      scala
        .Option(impl.clusters())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Cluster.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeClustersResponse.ReadOnly =
    new Wrapper(impl)
}
