package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClustersRequest(
    clusterName: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None,
    showShardDetails: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest = {
    import DescribeClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(showShardDetails.map(value => value: java.lang.Boolean))(
        _.showShardDetails
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeClustersRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeClustersRequest
      .wrap(buildAwsValue())
}
object DescribeClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeClustersRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeClustersRequest(
        clusterNameValue.map(value => value),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value),
        showShardDetailsValue.map(value => value)
      )
    def clusterNameValue: Option[String]
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def showShardDetailsValue: Option[BooleanOptional]
    def clusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterNameValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def showShardDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showShardDetails", showShardDetailsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeClustersRequest.ReadOnly {
    override def clusterNameValue: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def showShardDetailsValue: Option[BooleanOptional] =
      scala.Option(impl.showShardDetails()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeClustersRequest.ReadOnly =
    new Wrapper(impl)
}
