package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteUserResponse(
    user: Option[io.github.vigoo.zioaws.memorydb.model.User] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteUserResponse = {
    import DeleteUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse
      .wrap(buildAwsValue())
}
object DeleteUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse =
      io.github.vigoo.zioaws.memorydb.model
        .DeleteUserResponse(userValue.map(value => value.editable))
    def userValue: Option[io.github.vigoo.zioaws.memorydb.model.User.ReadOnly]
    def user: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
    ] = AwsError.unwrapOptionField("user", userValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteUserResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.ReadOnly {
    override def userValue
        : Option[io.github.vigoo.zioaws.memorydb.model.User.ReadOnly] = scala
      .Option(impl.user())
      .map(value => io.github.vigoo.zioaws.memorydb.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteUserResponse
  ): io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.ReadOnly =
    new Wrapper(impl)
}
