package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSubnetGroupRequest(subnetGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest = {
    import DeleteSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest
      .builder()
      .subnetGroupName(subnetGroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupRequest
      .wrap(buildAwsValue())
}
object DeleteSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupRequest =
      io.github.vigoo.zioaws.memorydb.model
        .DeleteSubnetGroupRequest(subnetGroupNameValue)
    def subnetGroupNameValue: String
    def subnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subnetGroupNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupRequest.ReadOnly {
    override def subnetGroupNameValue: String = impl.subnetGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest
  ): io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
