package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteParameterGroupResponse(
    parameterGroup: Option[
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse = {
    import DeleteParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse
      .builder()
      .optionallyWith(parameterGroup.map(value => value.buildAwsValue()))(
        _.parameterGroup
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse
      .wrap(buildAwsValue())
}
object DeleteParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse =
      io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse(
        parameterGroupValue.map(value => value.editable)
      )
    def parameterGroupValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly]
    def parameterGroup: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
    ] = AwsError.unwrapOptionField("parameterGroup", parameterGroupValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.ReadOnly {
    override def parameterGroupValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
    ] = scala
      .Option(impl.parameterGroup())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ParameterGroup.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse
  ): io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
