package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteClusterRequest(
    clusterName: String,
    finalSnapshotName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(finalSnapshotName.map(value => value: java.lang.String))(
        _.finalSnapshotName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteClusterRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteClusterRequest
      .wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DeleteClusterRequest =
      io.github.vigoo.zioaws.memorydb.model.DeleteClusterRequest(
        clusterNameValue,
        finalSnapshotNameValue.map(value => value)
      )
    def clusterNameValue: String
    def finalSnapshotNameValue: Option[String]
    def clusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterNameValue)
    def finalSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("finalSnapshotName", finalSnapshotNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteClusterRequest.ReadOnly {
    override def clusterNameValue: String = impl.clusterName(): String
    override def finalSnapshotNameValue: Option[String] =
      scala.Option(impl.finalSnapshotName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest
  ): io.github.vigoo.zioaws.memorydb.model.DeleteClusterRequest.ReadOnly =
    new Wrapper(impl)
}
